package planetarijum;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;

@SuppressWarnings("serial")
public class PlaneteCanvas extends Canvas {

	/*
	 * Lakse i brze je da se napravi apstraktna klasa Objekat i da njoj
	 * pripadaju nebeski objekti. To omogucava lakse dodavanje novih planeta i
	 * ne zahteva zakljucavanje koda jer svi imaju istu run metodu iz klase
	 * Objekat, i svi dobijaju procesorsko vreme u istom trenutku
	 */
	private Objekat[] obj;
	// konstantni uglovi potrebni za pomeraj
	public static double alpha;
	public static double beta;
	public static double gamma;
	public static double delta;
	public static double sigma;
	public static double mi;
	public static double eta;
	public static double ro;
	public static double ni;

	public PlaneteCanvas() {
		// velicina kanvasa
		setSize(1024, 768);
		// boja pozadine, recimo da je svemir crn
		setBackground(Color.BLACK);
		// staticki alociramo koliko je nebeskih objekata potrebno
		obj = new Objekat[10];

		// postavimo uglove na 0 radijana
		alpha = 0;
		beta = 0;
		gamma = 0;
		sigma = 0;
		delta = 0;
		mi = 0;
		eta = 0;
		ro = 0;
		ni = 0;

		// kreiramo jedan po jedan objekat
		// drugacije sam dodavao planete nego sto stvarno stoje u Suncevom
		// sistemu

		// ove promenljive predstavljaju rastojanje nebeskih objekata od onog
		// oko kojeg se krecu
		int rsunce = 0;
		obj[0] = new Sunce(512, 340, 50, rsunce, obj);
		int rmerkur = 40;
		obj[4] = new Merkur((int) (obj[0].getX() + rmerkur * Math.cos(delta)),
				(int) (obj[0].getY() + rmerkur * Math.sin(delta)), 10, rmerkur, obj);
		int rvenera = 70;
		obj[3] = new Venera((int) (obj[0].getX() + rvenera * Math.cos(gamma)),
				(int) (obj[0].getY() + rvenera * Math.sin(gamma)), 15, rvenera, obj);
		int rzemlja = 110;
		obj[1] = new Zemlja((int) (obj[0].getX() + rzemlja * Math.cos(alpha)),
				(int) (obj[0].getY() + rzemlja * Math.sin(alpha)), 20, rzemlja, obj);
		int rmesec = 25;
		obj[2] = new Mesec((int) (obj[1].getX() + rmesec * Math.cos(beta)),
				(int) (obj[1].getY() + rmesec * Math.sin(beta)), 5, rmesec, obj);
		int rmars = 155;
		obj[5] = new Mars((int) (obj[0].getX() + rmars * Math.cos(sigma)),
				(int) (obj[0].getY() + rmars * Math.sin(sigma)), 13, rmars, obj);
		int rjupiter = 195;
		obj[6] = new Jupiter((int) (obj[0].getX() + rjupiter * Math.cos(mi)),
				(int) (obj[0].getY() + rjupiter * Math.sin(mi)), 35, rjupiter, obj);
		int rsaturn = 240;
		obj[7] = new Saturn((int) (obj[0].getX() + rsaturn * Math.cos(eta)),
				(int) (obj[0].getY() + rsaturn * Math.sin(eta)), 25, rsaturn, obj);
		int ruran = 280;
		obj[8] = new Uran((int) (obj[0].getX() + ruran * Math.cos(eta)), (int) (obj[0].getY() + ruran * Math.sin(eta)),
				20, ruran, obj);
		int rneptun = 310;
		obj[9] = new Neptun((int) (obj[0].getX() + rneptun * Math.cos(eta)),
				(int) (obj[0].getY() + rneptun * Math.sin(eta)), 20, rneptun, obj);

		// startujemo niti
		for (Objekat o : obj)
			new Thread(o).start();
		// startujem i refresher klasu koja u odredjenom vremenskom intervalu
		// poziva run metodu
		new Thread(new Refresher(this)).start();

	}

	public void paint(Graphics g) {
		// iscrtavanje univerzuma (nije bas celog)
		for (Objekat o : obj)
			o.draw(g);

		// kada sam isrctao jednom odmah pomeram ugao
		// kako bi planete znale gde sledece da odu

		alpha += (2 * Math.PI) / 365; // zemlja +
		beta += (24 * Math.PI) / 365; // mesec +
		gamma += (3.6 * Math.PI) / 365; // venera +
		delta += (8 * Math.PI) / 365; // merkur +
		sigma += (1.2 * Math.PI) / 365; // mars +
		mi += (Math.PI / 6) / 365; // jupiter +
		eta += (Math.PI / 14) / 365; // saturn +
		ni += (Math.PI / 42) / 365; // uran +
		ro += (Math.PI / 82.5) / 365; // neptun +
	}
}
